<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product_translation}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M220329115740AddProductIdColumnToProductTranslationTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product_translation}}', 'product_id', $this->integer()->null());

        // creates index for column `product_id`
        $this->createIndex(
            '{{%idx-product_translation-product_id}}',
            '{{%product_translation}}',
            'product_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-product_translation-product_id}}',
            '{{%product_translation}}',
            'product_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-product_translation-product_id}}',
            '{{%product_translation}}'
        );

        // drops index for column `product_id`
        $this->dropIndex(
            '{{%idx-product_translation-product_id}}',
            '{{%product_translation}}'
        );

        $this->dropColumn('{{%product_translation}}', 'product_id');
    }
}
