<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.bitcream.it
 * @since             1.0.0
 * @package           Pim sync to wp
 *
 * @wordpress-plugin
 * Plugin Name:       Plugin pim for sync to wp
 * Plugin URI:        https://www.bitcream.it
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Bitcream
 * Author URI:        https://www.bitcream.it
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       thor
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'NDT_PIM_VERSION', '1.0.0' );

if (!defined('ABSPATH')) {
	die();
}

if (!class_exists('Pim_WP_Sync')) {

	class Pim_WP_Sync
	{

			public function __construct()
			{
				$this->constants();
				$this->includes();
			}

			public function constants()
			{
					if (!defined('PIM_SYNC_DIR')) {
							define('PIM_SYNC_DIR', plugin_dir_path(__FILE__));
					}

					if (!defined('PIM_SYNC_DIR_URL')) {
							define('PIM_SYNC_DIR_URL', plugin_dir_url(__FILE__));
					}
			}

			public function includes()
			{
                require_once PIM_SYNC_DIR . 'ndt-pim-sync-api.php';
			}

	}
	$pim_wp_sync = new Pim_WP_Sync();
}