<?php
/*
Plugin Name: Event API plugin
Plugin URI: http://emberware.it/
Description: Event API plugin
Author: Emberware
Version: 1.0
Author URI: http://emberware.it/
*/
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if (! class_exists ('PIM_SYNC_API')){
    class PIM_SYNC_API{
        public static function register_routes() {
            $version = '1';
            $namespace = 'pim/v' . $version;
            register_rest_route($namespace, 'products', array(
                'methods' => 'POST',
                'callback' => 'rest_post_product',
                )
            );
            register_rest_route($namespace, 'media', array(
                'methods' => 'POST',
                'callback' => 'rest_post_media',
                )
            );
            register_rest_route($namespace, 'taxonomy', array(
                'methods' => 'POST',
                'callback' => 'rest_post_taxonomy',
                )
            );
            register_rest_route($namespace, 'taxonomy-term', array(
                'methods' => 'POST',
                'callback' => 'rest_post_taxonomy_term',
                )
            );
            register_rest_route($namespace, 'translations', array(
                'methods' => 'POST',
                'callback' => 'rest_post_translations',
                )
            );
        }
        public static function init(){
            add_action( 'rest_api_init', array( __CLASS__, 'register_routes' ), 12 );
        }
    }
}
add_action ('plugins_loaded', array('PIM_SYNC_API', 'init'));

/**
 * Create and update product to wp
 */
function rest_post_product($request){

    // {
    //     "title": "Andromeda3",
    //     "description": "Andromeda description", 
    //     "meta": { 
    //             "_Codice": "124",          
    //             "_Codice_temporaneo": "1243",
    //             "_File_download_prodotto_id": 316,
    //             "_thumbnail_id": 694
    //     },
    //     "terms":  {
    //             "decors-category": [18]
    //     }
    // }
    
    $product_request = [        
        'post_title' => $request['title'],
        'post_content' => $request['description'],
        'post_type'   => 'decor',
        'post_status'   => 'publish',
    ];
    //$product_request['ID'] = $request['id'];
    if(isset($request['id']) && !empty($request['id'])){
        $product_request['ID'] = $request['id'];
    }
    $productId = wp_insert_post( $product_request );

    foreach($request['meta'] as $metaKey => $metaValue){
        update_post_meta($productId, $metaKey, $metaValue);
    }

    foreach($request['terms'] as $taxonomy => $taxonomyTermId){
        register_taxonomy( $taxonomy, 'decor');
        wp_set_post_terms( $productId, $taxonomyTermId, $taxonomy);
    }
    return $productId;
        
}

/**
 * Create and update product to wp
 */
function rest_post_translations($request){

    $my_translated_post = array(
        'post_title'    => $request['title'],
        'post_content'  => $request['description'],
        'post_status'   => 'publish',
        'post_type' => 'decor', 
    ); 
 
    // Insert the 2 posts into the database
    $original_post_id = $request['post_id'];
    $translated_post_id = wp_insert_post( $my_translated_post );
    
    // https://wpml.org/wpml-hook/wpml_element_type/
    $wpml_element_type = apply_filters( 'wpml_element_type', 'decor' );
        
    // get the language info of the original post
    // https://wpml.org/wpml-hook/wpml_element_language_details/
    $get_language_args = array('element_id' => $original_post_id, 'element_type' => 'decor' );
    $original_post_language_info = apply_filters( 'wpml_element_language_details', null, $get_language_args );
        
    $set_language_args = array(
        'element_id'    => $translated_post_id,
        'element_type'  => $wpml_element_type,
        'trid'   => $original_post_language_info->trid,
        'language_code'   => $request['language'],
        'source_language_code' => $original_post_language_info->language_code
    );

    do_action( 'wpml_set_element_language_details', $set_language_args );


    return $translated_post_id;
}



function rest_post_taxonomy($request){
    $terms_id = [];
    foreach($request['terms'] as $term){
        if(is_string($term)){
            $terms_id[] = insert_update_term($request['slug'], $term);
        }else{
            $term_id = insert_update_term($request['slug'], $term['title']);
            foreach($term['meta'] as $meta_key => $meta_value){
                update_term_meta( $term_id, $meta_key, $meta_value);
            }            
            $terms_id[] = $term_id;
        }  
    }
    return $terms_id;
}

function rest_post_taxonomy_term($request){    
    return insert_update_term($request['slug'], $request['term']);
}

function insert_update_term($taxonomy, $term){
    if(empty($term) && $term != '0') return;
    register_taxonomy( $taxonomy, 'decor');
    $wp_term = get_term_by( 'slug', $term, $taxonomy, ARRAY_A);
    if(empty($wp_term)) $wp_term = wp_insert_term( $term, $taxonomy);
    return $wp_term['term_id'];
}

function rest_post_media($request){
    $user_id = $current_user->ID;

    $file_params = $request->get_file_params();
    if (!isset($file_params['media']) || empty($file_params['media']) || $file_params['media']['size'] == 0) {
        $response = array(
            'code' => 'rest_missing_callback_param',
            'message' => 'Parametro(i) mancante(i): media',
            'data' => array(
                'status' => 400,
                'params' => array(
                    'media',
                ),
            ),
        );
        return new WP_REST_Response($response, 400);
    }

    $attach_id = upload_media($file_params['media']);

    return $attach_id;
}

/**
 * Create and update media to wp
 */
function upload_media($media_file, $postId = NULL){
    $file_name = date("Ymd-His") . $media_file['name'];
    $upload_dir = wp_upload_dir();
    $file_dest_path = trailingslashit($upload_dir['path']) . $file_name;
    move_uploaded_file($media_file['tmp_name'], $file_dest_path);

    $attachment = array(
        'guid' => $upload_dir['url'] . '/' . $file_name,
        'post_mime_type' => $media_file['type'],
        'post_title' => 'Media of '.$media_file['name'],
        'post_content' => 'Media of '.$media_file['name'],
        'post_status' => 'inherit',
    );
    $attach_id = wp_insert_attachment($attachment, $file_dest_path, 0);
    if ( ! function_exists( 'wp_generate_attachment_metadata' ) ) {
        include( ABSPATH . 'wp-admin/includes/image.php' );
    }
    $attach_data = wp_generate_attachment_metadata( $attach_id, $file_dest_path );
    wp_update_attachment_metadata( $attach_id,  $attach_data );
    return $attach_id;
}

// /**
//  * Set header element
//  */
// function pim_sync_rest_cors() {
// 	remove_filter( 'rest_pre_serve_request', 'rest_send_cors_headers' );
// 	add_filter( 'rest_pre_serve_request', function( $value ) {
// 		header( 'Access-Control-Allow-Origin: *' );
// 		header( 'Access-Control-Allow-Methods: *' );
// 		header( 'Access-Control-Allow-Headers: Authorization, Content-Type, zone-id' );
// 		header( 'Access-Control-Allow-Credentials: true' );
// 		header( 'Access-Control-Expose-Headers: Link', false );
// 		return $value;
// 	} );
// }
// add_action( 'rest_api_init', 'pim_sync_rest_cors', 15 );

