<?php

namespace bitcream\ndt\reservedarea\api\controllers;

use Yii;
use yii\rest\ActiveController;
use yii\filters\AccessControl;
use bitcream\ndt\reservedarea\api\models\Collection;
use bitcream\ndt\custom\common\models\CustomerUser;

class CollectionController extends ActiveController
{
    public $modelClass = 'bitcream\ndt\reservedarea\api\models\Collection';

    /**
     * @inheritdoc
    */

    public function behaviors(): array
    {
        return array_merge(parent::behaviors(), 
            [
                'authenticator' => [
                    'class' => \Kakadu\Yii2JwtAuth\JwtBearerAuth::class,
                    'except' => ['options'],
                ],
                'access'        => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'allow' => true,
                            'roles' => ['@'],
                        ],
                    ],
                ],
            ]
        );
    }

    public function actions(){
        $actions = parent::actions();

        $actions['index']['prepareDataProvider'] = [$this, 'prepareDataProvider'];

        return $actions;
    }

    public function prepareDataProvider(){

        $searchModel = new \bitcream\ndt\custom\common\models\CollectionSearch();
        return $searchModel->search(\Yii::$app->request->queryParams);
    }

}
