<?php

namespace bitcream\ndt\reservedarea\console\controllers;

use Yii;
use yii\console\Controller;
use yii\console\ExitCode;

/**
 * Manage users module permissions
 */
class RbacController extends Controller
{
    public $defaultAction ="init";

   /**
     * Init users permissions and assign the permissions to role
     */

    public function actionInit()
    {

        $auth = Yii::$app->authManager;
        // $auth->removeAll();
        $rule = $auth->getRule('ViewOwnContent');
        if( empty($rule)){
            $rule = new \bitcream\ndt\reservedarea\common\models\ViewOwnContent;
            $auth->add($rule);
        }

        // add the "ViewOwnContent" permission and associate the rule with it.
        $ViewOwnContent = $auth->getPermission('ViewOwnContent');
        if( empty($ViewOwnContent)){
              $ViewOwnContent  = $auth->createPermission('ViewOwnContent');
              $ViewOwnContent->description = 'visualizza solo il mio contenuto';
              $ViewOwnContent->ruleName = $rule->name;
              $auth->add($ViewOwnContent);
        };

        $viewCustomerItems = $auth->getPermission('viewCustomerItems');
        if( empty($viewCustomerItems)){
            $viewCustomerItems = $auth->createPermission('viewCustomerItems');
            $viewCustomerItems->description = 'permesso per menu per clienti';
            $auth->add($viewCustomerItems);
        }

        $viewCustomerUsersItems = $auth->getPermission('viewCustomerUsersItems');
        if( empty($viewCustomerUsersItems)){
            $viewCustomerUsersItems = $auth->createPermission('viewCustomerUsersItems');
            $viewCustomerUsersItems->description = 'permesso per menu per gli utenti dei clienti';
            $auth->add($viewCustomerUsersItems);
        }

        return ExitCode::OK;
    }
}