<?php

namespace bitcream\ndt\reservedarea\api\controllers;

use Yii;
use yii\rest\ActiveController;
use yii\filters\AccessControl;
use bitcream\ndt\reservedarea\api\models\CustomerUser;

class CustomerUserController extends ActiveController
{
    public $modelClass = 'bitcream\ndt\reservedarea\api\models\CustomerUser';

    /**
     * @inheritdoc
    */

    public function behaviors(): array
    {
        return array_merge(parent::behaviors(), 
            [
                'authenticator' => [
                    'class' => \Kakadu\Yii2JwtAuth\JwtBearerAuth::class,
                    'except' => ['options'],
                ],
                'access'        => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'allow' => true,
                            'roles' => ['@'],
                        ],
                    ],
                ],
            ]
        );
    }

    public function actions(){
        $actions = parent::actions();

        $actions['index']['prepareDataProvider'] = [$this, 'prepareDataProvider'];

        return $actions;
    }

    public function prepareDataProvider(){

        $searchModel = new \bitcream\ndt\custom\common\models\CustomerUserSearch();
        return $searchModel->search(\Yii::$app->request->queryParams);
    }

    public function actionMe(){
        return CustomerUser::findOne(Yii::$app->user->id);
    }

}
