<?php

namespace bitcream\ndt\reservedarea\api\controllers;

use Yii;
use yii\rest\ActiveController;
use yii\filters\AccessControl;
use bitcream\ndt\reservedarea\api\models\Collection;
use bitcream\ndt\custom\common\models\CustomerUser;
use yii\data\ActiveDataFilter;
use yii\data\ActiveDataProvider;

class CollectionController extends ActiveController
{
    public $modelClass = 'bitcream\ndt\reservedarea\api\models\Collection';

    /**
     * @inheritdoc
    */

    public function behaviors(): array
    {
        return array_merge(parent::behaviors(), 
            [
                'authenticator' => [
                    'class' => \Kakadu\Yii2JwtAuth\JwtBearerAuth::class,
                    'except' => ['options'],
                ],
                'access'        => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'allow' => true,
                            'roles' => ['@'],
                        ],
                    ],
                ],
            ]
        );
    }

    public function actions(){
        $actions = parent::actions();

        $actions['index']['prepareDataProvider'] = [$this, 'prepareDataProvider'];

        return $actions;
    }

    public function prepareDataProvider(){
        $filter = new ActiveDataFilter([
            'searchModel' => 'bitcream\ndt\reservedarea\api\models\CollectionSearch'
        ]);

        $filterCondition = null;
        
        // You may load filters from any source. For example,
        // if you prefer JSON in request body,
        // use Yii::$app->request->getBodyParams() below:
        if ($filter->load(\Yii::$app->request->get())) { 
            $filterCondition = $filter->build();
            if ($filterCondition === false) {
                // Serializer would get errors out of it
                return $filter;
            }
        }
        $query = Collection::find()->where(['customer_user_id' => Yii::$app->user->id]);
          
        if ($filterCondition !== null) {            
            $query->andWhere($filterCondition);
        }
        
        return new ActiveDataProvider([
            'query' => $query,
        ]);
    }

}
