<?php
namespace bitcream\ndt\sync\wp\common\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use emberware\evidia\sync\common\models\Sync;
use bitcream\ndt\sync\wp\common\models\SyncWpMedia;
use emberware\evidia\sync\common\behaviors\SyncStatusBehavior;

class SyncWpMediaBehavior extends SyncStatusBehavior
{
    /**
     * Restituisce il nome della classe di sincronizzazione
     */
    public static function getSyncClass(): string{
        return SyncWpMedia::class;
    }

    /**
     * Restituisce l'oggetto SyncWPMedia 
     * @return SyncWPMedia
     */
    public function getMediaObject(string $attribute = NULL){
        return $this->getSyncObject($attribute);
    }

    /**
     * Restituisce gli oggetti di SyncWPMedia 
     * @return SyncWPMedia[]
     */
    public function getMediaObjects(){
        return $this->getSyncObjects();
    }

    /**
     * Restituisce le properties di media
     */
    public function mediaSyncProperties(): array{
        return $this->syncAttributesProperties();
    }

}