<?php
namespace bitcream\ndt\sync\wp\common\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use emberware\evidia\sync\common\models\Sync;
use bitcream\ndt\sync\wp\common\models\SyncWpTaxonomy;
use emberware\evidia\sync\common\behaviors\SyncStatusBehavior;

class SyncWpTaxonomyBehavior extends SyncStatusBehavior
{
    /**
     * Restituisce il nome della classe di sincronizzazione
     */
    public static function getSyncClass(): string{
        return SyncWpTaxonomy::class;
    }

    /**
     * @deprecated: sostituita da funzione getTaxonomyRemoteObjects
     * Restituisce l'oggetto SyncWPTaxonomy 
     * @return SyncWPTaxonomy
     */
    public function getTaxonomyObject(string $attribute = NULL){
        return $this->getSyncObject($attribute);
    }

    /**
     * Restituisce l'oggetto SyncWPTaxonomy 
     * @return int[]
     */
    public function getTaxonomyRemoteObjects(string $attribute = NULL){
        $remoteObject = $this->getTaxonomyObject($attribute)->remote_object;
        return array_map('intval', explode(",", $remoteObject));
    }

    /**
     * Restituisce gli oggetti di SyncWPTaxonomy 
     * @return SyncWPTaxonomy
     */
    public function getTaxonomyObjects(){
        return $this->getSyncObjects();
    }

    /**
     * Restituisce le properties di taxonomy
     */
    public function taxonomySyncProperties(): array{
        return $this->syncAttributesProperties();
    }

}