<?php

namespace bitcream\ndt\sync\wp\common\models;
use emberware\evidia\sync\common\models\Sync;
use Yii;

/**
 * This is the model extends model Sync 
 */
class SyncWpMedia extends Sync
{
    /**
     * Restituisce la classe di sincronizzazione
     */
    public static function getSyncClassName(): string{
        return "wp-media";
    } 

    public function getSyncProperties(): array{
        return $this->class->mediaSyncProperties();
    }

    /**
     * Function for get element media to sync
     */
    public function upload(){
        $postFields = [];
        $syncProperties = $this->syncProperties;
        foreach($this->syncProperties[$this->object_attribute] as $syncProperty){
            if(isset($syncProperty['filename'])){
                $mimeType = mime_content_type( $syncProperty['path'] );
                $postFields['media'] = curl_file_create($syncProperty['path'], $mimeType, $syncProperty['filename']);
            }            
        }
        
        if(!empty($postFields)){
            $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => Yii::$app->params['wpSyncUrl'].'/media',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $postFields,            
            CURLOPT_HTTPHEADER => array(
                'Authorization: Jwt '.Yii::$app->params['wpSyncToken'],
            ),
            ));
    
            $response = curl_exec($curl);
    
            curl_close($curl);
    
            if($response){
                return $response;
            }else{
                return false;
            }
        }
        
    }
}
    