<?php
namespace bitcream\ndt\sync\wp\common\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use emberware\evidia\sync\common\models\Sync;
use bitcream\ndt\sync\wp\common\models\SyncWpProduct;
use emberware\evidia\sync\common\behaviors\SyncStatusBehavior;

class SyncWpProductBehavior extends SyncStatusBehavior
{
    /**
     * Restituisce il nome della classe di sincronizzazione
     */
    public static function getSyncClass(): string{
        return SyncWpProduct::class;
    }

    /**
     * Restituisce l'oggetto SyncWPProduct 
     * @return SyncWPProduct
     */
    public function getProductObject(){
        return $this->getSyncObject();
    }

    /**
     * Restituisce le properties di product
     */
    public function productSyncProperties(): array{
        return $this->syncProperties();
    }

}