<?php
namespace bitcream\ndt\sync\wp\common\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use emberware\evidia\sync\common\models\Sync;
use bitcream\ndt\sync\wp\common\models\SyncWpProductTranslation;
use emberware\evidia\sync\common\behaviors\SyncStatusBehavior;

class SyncWpProductTranslationBehavior extends SyncStatusBehavior
{
    /**
     * Restituisce il nome della classe di sincronizzazione
     */
    public static function getSyncClass(): string{
        return SyncWpProductTranslation::class;
    }

    /**
     * Restituisce l'oggetto SyncWpProductTranslation 
     * @return SyncWpProductTranslation
     */
    public function getProductObject(){
        return $this->getSyncObject();
    }

    /**
     * Restituisce le properties di product
     */
    public function productTranslationSyncProperties(): array{
        return $this->syncAttributesProperties();
    }

    public function needSync(string $attribute): bool{
        if(!$this->owner->needPublish()) return false;
        return parent::needSync($attribute);
    }
    
}