<?php

namespace bitcream\ndt\sync\wp\common\models;
use emberware\evidia\sync\common\models\Sync;
use Yii;

/**
 * This is the model extends model Sync 
 */
class SyncWpTaxonomy extends Sync
{
    /**
     * Restituisce la classe di sincronizzazione
     */
    public static function getSyncClassName(): string{
        return "wp-taxonomy";
    } 

    public function getSyncProperties(): array{
        return $this->class->taxonomySyncProperties();
    }

    /**
     * Function for get element taxonomy to sync
     */
    public function upload(){

        $syncProperties = $this->syncProperties[$this->object_attribute];
        $route = '/taxonomy-term';
        if(isset($syncProperties['taxonomy']['terms'])){
            $route = '/taxonomy';
        }
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => Yii::$app->params['wpSyncUrl'].$route,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($syncProperties['taxonomy']),
        CURLOPT_HTTPHEADER => array(
            'Authorization: Jwt '.Yii::$app->params['wpSyncToken'],
            'Content-Type: application/json'
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        if($response){
            if(isset($syncProperties['taxonomy']['terms'])){
                return implode(",", json_decode($response));
            }
            return (string)json_decode($response);
        }else{
            return false;
        }
    }

}
    