<?php
namespace bitcream\ndt\sync\wp\common\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use emberware\evidia\sync\common\models\Sync;
use bitcream\ndt\sync\wp\common\models\SyncWpMedia;
use emberware\evidia\sync\common\behaviors\SyncStatusBehavior;

class SyncWpMediaBehavior extends SyncStatusBehavior
{
    /**
     * Restituisce il nome della classe di sincronizzazione
     */
    public static function getSyncClass(): string{
        return SyncWpMedia::class;
    }

    /**
     * Restituisce l'oggetto SyncWPMedia 
     * @return SyncWPMedia
     */
    public function getMediaObject(string $attribute = NULL){
        return $this->getSyncObject($attribute);
    }

    /**
     * Restituisce gli oggetti di SyncWPMedia 
     * @return SyncWPMedia[]
     */
    public function getMediaObjects(){
        return $this->getSyncObjects();
    }

    /**
     * Restituisce l'oggetto SyncWPTaxonomy 
     * @return int[]
     */
    public function getGalleryMediaObjects(string $attribute = NULL){
        $remoteObject = $this->getMediaObject($attribute)->remote_object;
        return array_map('intval', explode(",", $remoteObject));
    }

    /**
     * Restituisce le properties di media
     */
    public function mediaSyncProperties(): array{
        return $this->syncAttributesProperties();
    }

    /**
     * Verifica che l'oggetto può essere sincronizzato
     */
    public function needSync(string $attribute): bool{
        $objectAttribute = $this->owner->$attribute;
        //controlla che l'objectAttribute non sia vuoto
        if(empty($objectAttribute)) return false;
        if(is_array($objectAttribute)){
            $objectAttribute = $objectAttribute[0];
        }
        //se non è un file non è da sincronizzare
        if(get_class($objectAttribute) == "floor12\files\models\File") return false;
        //se è già stata fatta una sincronizzazione recente non viene sincronizzato
        $sync = static::getsyncClass()::findSyncStatus($this->owner->className(), $this->owner->id, $attribute);
        if(!empty($sync) && !empty($sync->remote_object) && ($objectAttribute->created < (int)$sync->updated_at)) return false;
        if(!$this->owner->needPublish()) return false;
        return parent::needSync($attribute);
    }

}