<?php

namespace bitcream\ndt\sync\wp\common\models;
use emberware\evidia\sync\common\models\Sync;
use bitcream\ndt\sync\wp\common\models\Product;
use bitcream\ndt\sync\wp\common\models\ProductTranslation;
use Yii;

/**
 * This is the model extends model Sync 
 */
class SyncWpProductTranslation extends Sync
{
    /**
     * Restituisce la classe di sincronizzazione
     */
    public static function getSyncClassName(): string{
        return "wp-product-translation";
    } 

    public function getSyncProperties(): array{
        return $this->class->productTranslationSyncProperties();
    }

    /**
     * Function for get element product to sync
     */
    public function upload(): string{

        $syncProperties = $this->syncProperties[$this->object_attribute];       
        if(!empty($this->remote_object)){
            $syncProperties['id'] = $this->remote_object;
        }
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => Yii::$app->params['wpSyncUrl'].'/translations',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($syncProperties),
        CURLOPT_HTTPHEADER => array(
            'Authorization: Jwt '.Yii::$app->params['wpSyncToken'],
            'Content-Type: application/json'
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        if($response){
            return $response;
        }else{
            return false;
        }
    }

}
    