<?php


use yii\helpers\Html;
use yii\widgets\ActiveForm;
use Emberware\Evidia\Toolkit\Field\WYSIWYG;
//use Emberware\Evidia\Toolkit\Field\Select2;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model bitcream\pim\custom\common\models\ProductModel */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="product-model-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'description')->widget(WYSIWYG::className()) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <label class="control-label">Attributes</label>
            <?php echo Select2::widget([
                'name' => 'attribute_ids',
                'class' => 'form-group attribute_ids form-control',
                'value' => ArrayHelper::map($model->attributesObject, 'id', function ($attribute) {
                    return $attribute['id'];
                }),
                'id' => 'attribute_ids',
                'data' => ArrayHelper::map($attributes, 'id', function ($attribute) {
                    return $attribute['title'];
                }),
                'options' => ['multiple' => true, 'placeholder' => Yii::t('app', 'Select attribute')]
            ]);?>
        </div>
    </div>
    <br>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
