<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use Emberware\Evidia\Toolkit\Field\WYSIWYG;
//use Emberware\Evidia\Toolkit\Field\Select2;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model bitcream\pim\custom\common\models\Product */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="product-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'short_title')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'description')->widget(WYSIWYG::className()) ?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'product_model_id')->widget(Select2::classname(), [
                'name' => 'product_model_id',
                'class' => 'form-group product_model_ids form-control',
                'value' => ArrayHelper::map($productModels, 'id', function ($productModel) {
                    return $productModel['name'];
                }),
                'id' => 'product_model_id',
                'data' => ArrayHelper::map($productModels, 'id', function ($productModel) {
                    return $productModel['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select product model')]
            ])->label(Yii::t('app', 'Product model'));?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
        <label class="control-label">Attributes</label>
            <?php echo Select2::widget([
                'name' => 'attribute_ids',
                'class' => 'form-group attribute_ids form-control',
                'value' => ArrayHelper::map($model->attributesObject, 'id', function ($attribute) {
                    return $attribute['id'];
                }),
                'id' => 'attribute_ids',
                'data' => ArrayHelper::map($attributes, 'id', function ($attribute) {
                    return $attribute['title'];
                }),
                'options' => ['multiple' => true, 'placeholder' => Yii::t('app', 'Select attribute')]
            ]);?><br>
        </div>
    </div>
    <!-- <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'image')->textarea(['rows' => 6]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'gallery')->textarea(['rows' => 6]) ?>
        </div>
    </div> -->

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
