<?php

namespace bitcream\pim\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use bitcream\pim\custom\common\behaviors\StatusBehaviors;
use bitcream\pim\custom\common\behaviors\CreateUpdateBehaviors;
use bitcream\pim\custom\common\models\ProductModel;
/**
 * This is the model class for table "{{%product_model}}".
 *
 */
class ProductModel extends base\ProductModel
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    /**
     * save Category
     */
    public function saveAttributes($attribute_ids)
    {
        /* clear the Category of the post before saving */
        ProductDefinition::deleteAll(['attribute_id' => $this->id]);
        if (is_array($attribute_ids)) {
            foreach($attribute_ids as $attributeId) {
                $spm = new ProductDefinition();
                $spm->product_model_id = $this->id;
                $spm->attribute_id = $attributeId;
                $spm->save();
            }
        }
    }

    public function getAttributesObject()
    {
        return $this->hasMany(Attribute::className(), ['id' => 'attribute_id'])
            ->via('productDefinitions');
    }
}
