<?php
namespace bitcream\pim\custom\common\widget;

use yii\helpers\Html;
use yii\widgets\InputWidget;
use Yii;
use yii\helpers\ArrayHelper;

class ProductFieldWidget extends InputWidget
{
    private $configuration;
    public $options;
    public function init()
    {
        parent::init();
        $this->setDefaultConfiguration();
    }

    public function run()
    {
        $attribute = $this->model->getDynamicAttribute($this->attribute);
        switch ($attribute->type) {
            case 'si-no':
                return \Emberware\Evidia\Toolkit\Field\SwitchInput::Widget($this->configuration);
                break;
            case 'date':
                return \Emberware\Evidia\Toolkit\Field\Date::Widget($this->configuration);
                break;
            case 'selezione-singola':
                return \kartik\select2\Select2::widget($this->selectConfiguration($this->attribute));
                break;
            case 'selezione-multipla':
                return \kartik\select2\Select2::widget($this->selectConfiguration($this->attribute, true));
                break;
            case 'immagine':
            case 'file':
                return \floor12\files\components\FileInputWidget::widget($this->configuration);
                break;
            case 'testo':
            default:
                return Html::activeTextInput($this->model, $this->attribute, ['class' => 'form-control']);
                break;
        }
    }

    private function setDefaultConfiguration(){
        $this->configuration = [
            'model' => $this->model,
            'attribute' => $this->attribute,        
        ];
    }

    private function selectConfiguration(string $attribute, bool $multiple = false){
        return ArrayHelper::merge($this->configuration, [
            'name' => $attribute,
            'data' => static::attributeData($attribute),
            'value' => $this->model->$attribute,
            'options' => [
                'placeholder' => 'Select a '.$attribute.' ...',
                'multiple' => $multiple,
            ],
        ]);
    }

    public static function attributeData($attribute){
        return [];
    }
}