<?php

namespace bitcream\pim\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M220126104250AddProductParentIdColumnToProductTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product}}', 'product_parent_id', $this->integer()->null());

        // creates index for column `product_parent_id`
        $this->createIndex(
            '{{%idx-product-product_parent_id}}',
            '{{%product}}',
            'product_parent_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-product-product_parent_id}}',
            '{{%product}}',
            'product_parent_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-product-product_parent_id}}',
            '{{%product}}'
        );

        // drops index for column `product_parent_id`
        $this->dropIndex(
            '{{%idx-product-product_parent_id}}',
            '{{%product}}'
        );

        $this->dropColumn('{{%product}}', 'product_parent_id');
    }
}
