<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use Emberware\Evidia\Toolkit\Field\WYSIWYG;
//use Emberware\Evidia\Toolkit\Field\Select2;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model bitcream\pim\custom\common\models\Product */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="product-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'short_title')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'description')->widget(WYSIWYG::className()) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'product_parent_id')->widget(Select2::classname(), [
                'name' => 'product_parent_id',
                'class' => 'form-group product_parent_ids form-control',
                'value' => ArrayHelper::map($productParents, 'id', function ($productParent) {
                    return $productParent['title'];
                }),
                'id' => 'product_parent_id',
                'data' => ArrayHelper::map($productParents, 'id', function ($productParent) {
                    return $productParent['title'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select product parent')]
            ])->label(Yii::t('app', 'Product parent'));?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'product_model_id')->widget(Select2::classname(), [
                'name' => 'product_model_id',
                'class' => 'form-group product_model_ids form-control',
                'value' => ArrayHelper::map($productModels, 'id', function ($productModel) {
                    return $productModel['name'];
                }),
                'id' => 'product_model_id',
                'data' => ArrayHelper::map($productModels, 'id', function ($productModel) {
                    return $productModel['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select product model')]
            ])->label(Yii::t('app', 'Product model'));?>
        </div>
    </div>
    <!-- <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'image')->textarea(['rows' => 6]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'gallery')->textarea(['rows' => 6]) ?>
        </div>
    </div> -->

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
