<?php

namespace bitcream\pim\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use bitcream\pim\custom\common\behaviors\StatusBehaviors;
use bitcream\pim\custom\common\behaviors\CreateUpdateBehaviors;
use floor12\files\models\File;
/**
 * This is the model class for table "{{%product_value}}".
 *
 */
class ProductValue extends base\ProductValue
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'file',
                ],
            ],
       ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            // each category_id must exist in category table (*1)
            ['file', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'file' => Yii::t('app', 'File'),
        ]);
    }

    /**
     * Gets query for [[attributeObject]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAttributeObject()
    {
        return $this->hasOne(Attribute::className(), ['id' => 'attribute_id']);
    }

    public static function find(){
        return parent::find()->where([
            'status' => 30, //prodotti non cancellati
        ]);
    }

    /**
     * @return string|false fileId
     */
    public function getFileId(){
        $file = File::findOne(['object_id' => $this->id, 'class' => self::class, 'field' => 'file']);
        if(!empty($file)) return $file->id;
        return false;
    }

    public function saveFile($ids){
        $order = 0;
        if ($ids) foreach ($ids as $id) {
            if (empty($id))
                continue;
            $file = File::findOne($id);
            if ($file) {
                $file->object_id = $this->id;
                $file->class = self::class;
                $file->field = "file";
                $file->ordering = $order++;
                $file->save();
                if (!$file->save()) {
                    throw new ErrorException('Unable to update File object');
                }
            }
        }
    }

    public function unlinkFile(){
        Yii::$app->db->createCommand()->update(
            "{{%file}}",
            ['object_id' => 0],
            [
                'class' => self::class,
                'object_id' => $this->id,
                'field' => "file",
            ]
        )->execute();
    }
}
