<?php

namespace bitcream\pim\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "attribute".
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $slug
 * @property string|null $description
 * @property string|null $type
 * @property int|null $translatable
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 *
 * @property AttributeTranslation[] $attributeTranslations
 * @property ProductDefinition[] $productDefinitions
 * @property ProductValue[] $productValues
 */
class Attribute extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'attribute';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['description'], 'string'],
            [['translatable', 'status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['title', 'slug', 'type', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'title' => Yii::t('app', 'Title'),
            'slug' => Yii::t('app', 'Slug'),
            'description' => Yii::t('app', 'Description'),
            'type' => Yii::t('app', 'Type'),
            'translatable' => Yii::t('app', 'Translatable'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
        ];
    }

    /**
     * Gets query for [[AttributeTranslations]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAttributeTranslations()
    {
        return $this->hasMany(AttributeTranslation::className(), ['attribute_id' => 'id']);
    }

    /**
     * Gets query for [[ProductDefinitions]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductDefinitions()
    {
        return $this->hasMany(ProductDefinition::className(), ['attribute_id' => 'id']);
    }

    /**
     * Gets query for [[ProductValues]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductValues()
    {
        return $this->hasMany(ProductValue::className(), ['attribute_id' => 'id']);
    }
}
