<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel bitcream\pim\custom\backend\models\ProductDefinitionSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Product Definitions');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="product-definition-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Create Product Definition'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'status',
            'created_at',
            'created_user_id',
            'updated_at',
            //'updated_user_id',
            //'attribute_id',
            //'product_model_id',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>


</div>
