<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
//use Emberware\Evidia\Toolkit\Field\Select2;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
/* @var $this yii\web\View */
/* @var $model bitcream\pim\custom\common\models\ProductValue */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="product-value-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'product_id')->widget(Select2::classname(), [
                'name' => 'product_id',
                'class' => 'form-group product_ids form-control',
                'value' => ArrayHelper::map($products, 'id', function ($product) {
                    return $product['title'];
                }),
                'id' => 'product_id',
                'data' => ArrayHelper::map($products, 'id', function ($product) {
                    return $product['title'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select product')]
            ])->label(Yii::t('app', 'Product'));?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'attribute_id')->widget(Select2::classname(), [
                'name' => 'attribute_id',
                'class' => 'form-group attribute_ids form-control',
                'value' => ArrayHelper::map($attributes, 'id', function ($attribute) {
                    return $attribute['title'];
                }),
                'id' => 'attribute_id',
                'data' => ArrayHelper::map($attributes, 'id', function ($attribute) {
                    return $attribute['title'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select attribute')]
            ])->label(Yii::t('app', 'Attribute'));?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'value')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?=$form->field($model, 'file')->widget(floor12\files\components\FileInputWidget::class) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'language')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'type_of_hierarchy')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    
    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
