<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;

?>
<div class="datatable">
        <?=
        Datatable::widget([
            'dataProvider' => $dataProvider,
            'id' => 'product-model-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->name, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "paging" => false,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>