<?php

namespace bitcream\pim\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use bitcream\pim\custom\common\behaviors\StatusBehaviors;
use bitcream\pim\custom\common\behaviors\CreateUpdateBehaviors;
use bitcream\pim\custom\common\models\ProductModel;
use yii\behaviors\SluggableBehavior;
/**
 * This is the model class for table "{{%product_model}}".
 *
 */
class ProductModel extends base\ProductModel
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'slug' => [
                'class' => 'skeeks\yii2\slug\SlugBehavior',
                'slugAttribute' => 'slug',                      //The attribute to be generated
                'attribute' => 'name',       
                'slugifyOptions' => [
                    //'lowercase' => true,
                    'separator' => '_',
                    //'trim' => true
                    //'regexp' => '/([^A-Za-z0-9]|-)+/',
                    //'rulesets' => ['russian'],
                    //@see all options https://github.com/cocur/slugify
                ]
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    /**
     * save Category
     */
    public function saveAttributes($attribute_ids)
    {
        /* clear the Category of the post before saving */
        ProductDefinition::deleteAll(['product_model_id' => $this->id]);
        if (is_array($attribute_ids)) {
            foreach($attribute_ids as $attributeId) {
                $spm = new ProductDefinition();
                $spm->product_model_id = $this->id;
                $spm->attribute_id = $attributeId;
                $spm->save();
            }
        }
    }

    public function getAttributesObject()
    {
        return $this->hasMany(Attribute::className(), ['id' => 'attribute_id'])
            ->via('productDefinitions');
    }
}
