<?php

namespace bitcream\pim\custom\console\controllers;

use Yii;
use yii\console\Controller;
use yii\console\ExitCode;

/**
 * Manage users module permissions
 */
class RbacController extends Controller
{
    public $defaultAction ="init";

   /**
     * Init users permissions and assign the permissions to role
     */

    public function actionInit()
    {

        $auth = Yii::$app->authManager;
        
        // add the "updateOwnPost" permission and associate the rule with it.
        $ViewPimAdmin = $auth->getPermission('ViewPimAdmin');
        if( empty($ViewPimAdmin)){
              $ViewPimAdmin  = $auth->createPermission('ViewPimAdmin');
              $ViewPimAdmin->description = 'visualizza menu pim';
              $auth->add($ViewPimAdmin);
        };

        $adminRole = $auth->getRole('admin');
        if($adminRole){
            if(!$auth->hasChild($adminRole, $ViewPimAdmin)){
                $auth->addChild($adminRole, $ViewPimAdmin);
            }
        };

        return ExitCode::OK;
    }

}
