<?php

namespace bitcream\pim\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product_attribute}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M220114131305AddProductIdColumnToProductAttributeTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product_attribute}}', 'product_id', $this->integer()->null());

        // creates index for column `product_id`
        $this->createIndex(
            '{{%idx-product_attribute-product_id}}',
            '{{%product_attribute}}',
            'product_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-product_attribute-product_id}}',
            '{{%product_attribute}}',
            'product_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-product_attribute-product_id}}',
            '{{%product_attribute}}'
        );

        // drops index for column `product_id`
        $this->dropIndex(
            '{{%idx-product_attribute-product_id}}',
            '{{%product_attribute}}'
        );

        $this->dropColumn('{{%product_attribute}}', 'product_id');
    }
}
