<?php

namespace bitcream\pim\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "attribute_translation".
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $description
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $attribute_id
 *
 * @property Attribute $attributeObject
 */
class AttributeTranslation extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'attribute_translation';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['description'], 'string'],
            [['status', 'created_user_id', 'updated_user_id', 'attribute_id'], 'integer'],
            [['title', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['attribute_id'], 'exist', 'skipOnError' => true, 'targetClass' => Attribute::className(), 'targetAttribute' => ['attribute_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'title' => Yii::t('app', 'Title'),
            'description' => Yii::t('app', 'Description'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
            'attribute_id' => Yii::t('app', 'Attribute ID'),
        ];
    }

    /**
     * Gets query for [[Attribute]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAttributeObject()
    {
        return $this->hasOne(Attribute::className(), ['id' => 'attribute_id']);
    }
}
