<?php

namespace bitcream\pim\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\pim\custom\common\models\ProductModelValue;

/**
 * ProductModelValueSearch represents the model behind the search form of `bitcream\pim\custom\common\models\ProductModelValue`.
 */
class ProductModelValueSearch extends ProductModelValue
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'attribute_id', 'product_model_id'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ProductModelValue::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        
        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'attribute_id' => $this->attribute_id,
            'product_model_id' => $this->product_model_id,
        ]);

        return $dataProvider;
    }
}
