<?php

use yii\helpers\Html;
use Emberware\Evidia\Model\Datatable\common\models\DataTableCustom;

?>
<div class="attribute-value-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'attribute-value-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'id'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->id, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                ['attribute'=>Yii::t('app', 'Attribute'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return (isset($data->attributeObject)? $data->attributeObject->title: "");}
                ],
                'title',
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => true, 'view' => true],
                ],
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>