<?php

namespace bitcream\pim\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\pim\custom\common\behaviors\StatusBehaviors;
use bitcream\pim\custom\common\behaviors\CreateUpdateBehaviors;
use bitcream\pim\custom\common\models\ProductModel;

/**
 * This is the model class for table "{{%product}}".
 *
 */
class Product extends base\Product
{
    public static $modelSlug = "";
    public static $modelParent = "";
     
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            [['title'], 'required'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
        ]);
    }


    public function init()
    {
        parent::init();
        $this->setProductModel();
    }

    /**
     * Gets query for [[ProductModel]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductModel()
    {
        return $this->hasOne(ProductModel::className(), ['id' => 'product_model_id']);
    }

    /**
     * Gets query for [[ProductValues]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductValues()
    {
        return $this->hasMany(ProductValue::className(), ['product_id' => 'id']);
    }

    /**
     * Gets query for [[ProductParentl]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductParent()
    {
        return $this->hasOne(Product::className(), ['id' => 'product_parent_id']);
    }

    /**
     * @return ProductValue|false
     */
    public function getDynamicProductValue(string $attribute){
        foreach($this->productValues as $productValue){
            if($productValue->attributeObject->slug == $attribute){
                return $productValue;
            }
        }
        return false;
    }

    public function getDynamicAttributeValue(string $attribute){        
        $productValue = $this->getDynamicProductValue($attribute);
        if(empty($productValue)){
            return;
        }
        if($productValue->attributeObject->isFile()){
            return $productValue->file;
        }
        if(@unserialize($productValue->value) == true){
            $value = unserialize($productValue->value);
            return $value;
        }
        return $productValue->value;
    }

    public function getDynamicAttribute(string $attributeSlug){  
        //casistica multipla
        foreach($this->productModel->attributesObject as $attribute){
            if($attribute->slug == $attributeSlug){
                return $attribute;
            }
        }
        return false;
    }

    /**
     * $value string|array
     */
    public function createDynamicAttribute(string $attribute, $value){
        $attribute = Attribute::findOne(['slug' => $attribute]);
        $productValue = new ProductValue();
        $productValue->attribute_id = $attribute->id;
        $productValue->product_id = $this->id;
        (is_array($value))? $productValue->value = serialize($value): $productValue->value = $value;
        $productValue->save();
        if($productValue->attributeObject->isFile()){
            return $productValue->saveFile($value);                    
        }
       
    }

    public function setDynamicAttribute(string $attribute, $value){ 
        foreach($this->productValues as $productValue){
            if($productValue->attributeObject->slug == $attribute){
                if($productValue->attributeObject->isFile()){
                    $productValue->saveFile($value);                    
                }
                if(is_array($value)) $value = serialize($value);
                $productValue->value = $value;             
                $productValue->save();
                $productValue->restore();
                return;
            }
        }
        $this->createDynamicAttribute($attribute, $value);        
        return;
    }

    public function saveDynamicAttributes(array $attributesToSave){
        if(isset($attributesToSave['ProductValue'])){
            $this->setProductFiles($attributesToSave['ProductValue']['file_ids']);
        }
        foreach($this->productModel->attributesObject as $attribute){
            $attributeSlug = $attribute->slug;
            $attributeToSearch = $attribute->slug;
            if($attribute->isFile()){
                $attributeToSearch = $attributeSlug."_ids";                
            }
            if(array_key_exists($attributeToSearch, $attributesToSave)){            
                $this->$attributeSlug = $attributesToSave[$attributeToSearch];                
                $this->save();
            }                
        }
    }

    public function setProductFiles($fileIds){
        foreach($this->productValues as $productValue){
            if($productValue->attributeObject->isFile() && !empty($productValue->fileId) && !in_array($productValue->fileId, $fileIds)) {
                $productValue->unlinkFile();
                $productValue->delete();
            }
        }
    }

    public function setProductModel(){
        if(empty(static::$modelSlug)) return;
        $productModel = ProductModel::findOne(['slug' => static::$modelSlug]);
        $this->product_model_id = $productModel->id;
    }

    public static function find(){
        if(empty(static::$modelSlug)) return parent::find();
        $productModel = ProductModel::findOne(['slug' => static::$modelSlug]);
        return parent::find()->where([
            'product_model_id' => $productModel->id, 
            'status' => 30, //prodotti non cancellati
        ]);
    }

    public function getProductParents(){
        if(empty(static::$modelParent)) return [];
        $productParent = ProductModel::findOne(['slug' => static::$modelParent]);
        return Product::find()->where(['product_model_id' => $productParent->id, 'status' => 30])->all();
    }
    /**
     * Restituisce un array con le caratteristiche dei file legati all'attributo
     * @return array|false
     */
    public function getDynamicProductMediaFile(string $attribute){
        $media = [];
        if(empty($this->getDynamicAttributeValue($attribute))) return false;
        foreach($this->getDynamicAttributeValue($attribute) as $file){
            $media[] = [
                'filename' => $file->title,
                'path' => Yii::getAlias('@app/storage').$file->filename
            ];
        }        
        return $media;
    }

    public function getImageFields(string $attribute){
        $imageFields = [];
        $attributo = $this->getDynamicAttributeValue($attribute);
        if(isset($this->$attribute)){
            foreach($this->$attribute as $attributeFile){
                $href = str_replace('api', 'backend', Yii::$app->params['serverName'].$attributeFile->href);
                $imageFields[] = [
                    'href' => $href,
                    'type' => $attributeFile->content_type,
                    'size' => $attributeFile->size,                   
                ];
            }
            return $imageFields;
        }
        return "";
    }
}
