<?php

namespace bitcream\pim\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%attribute_value}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%attribute}}`
 */
class M220614100729AddAttributeIdColumnToAttributeValueTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%attribute_value}}', 'attribute_id', $this->integer()->null());

        // creates index for column `attribute_id`
        $this->createIndex(
            '{{%idx-attribute_value-attribute_id}}',
            '{{%attribute_value}}',
            'attribute_id'
        );

        // add foreign key for table `{{%attribute}}`
        $this->addForeignKey(
            '{{%fk-attribute_value-attribute_id}}',
            '{{%attribute_value}}',
            'attribute_id',
            '{{%attribute}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%attribute}}`
        $this->dropForeignKey(
            '{{%fk-attribute_value-attribute_id}}',
            '{{%attribute_value}}'
        );

        // drops index for column `attribute_id`
        $this->dropIndex(
            '{{%idx-attribute_value-attribute_id}}',
            '{{%attribute_value}}'
        );

        $this->dropColumn('{{%attribute_value}}', 'attribute_id');
    }
}
