<?php

use yii\helpers\Html;
use Emberware\Evidia\Model\Datatable\common\models\DataTableCustom;

?>
<div class="product-model-value-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'product-model-value-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'id'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->id, [Yii::$app->controller->id.'/view','id'=>$data->id]);}
                ],
                ['attribute'=>Yii::t('app', 'Attribute'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return (isset($data->attributeObject)? $data->attributeObject->title: "");}
                ],
                ['attribute'=>Yii::t('app', 'ProductModel'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return (isset($data->productModel)? $data->productModel->name: "");}
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>