<?php

namespace bitcream\pim\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\pim\custom\common\behaviors\StatusBehaviors;
use bitcream\pim\custom\common\behaviors\CreateUpdateBehaviors;
use yii\behaviors\SluggableBehavior;
/**
 * This is the model class for table "{{%attribute}}".
 *
 */
class Attribute extends base\Attribute
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'slug' => [
                'class' => 'skeeks\yii2\slug\SlugBehavior',
                'slugAttribute' => 'slug',                      //The attribute to be generated
                'attribute' => 'title',
                'slugifyOptions' => [
                    //'lowercase' => true,
                    'separator' => '_',
                    //'trim' => true
                    //'regexp' => '/([^A-Za-z0-9]|-)+/',
                    //'rulesets' => ['russian'],
                    //@see all options https://github.com/cocur/slugify
                ]
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    public function isFile(): bool{
        $fileList = [
            'immagine',
            'galleria-immagini',
            'file',
        ];

        if(in_array($this->type, $fileList)) return true;

        return false;
    }

    public function isModelValue(): bool{
        $modelList = [
            'selezione-singola-modello',
            'selezione-multipla-modello',
        ];

        if(in_array($this->type, $modelList)) return true;

        return false;
    }

    public function isSelectValue(): bool{
        $selectList = [
            'selezione-singola',
            'selezione-multipla',
        ];

        if(in_array($this->type, $selectList)) return true;

        return false;
    }

    // public function getValuesArray(){
    //     // if($this->isModelValue()) //dati modelli
    //     // if($this->isSelectValue()) //dati attribute value
    //     return [];
    // }

    // public function getValues(){

    // }

    public function getProductModels()
    {
        return $this->hasMany(ProductModel::className(), ['id' => 'product_model_id'])
            ->via('productModelValues');
    }

    public static function findAllSlugs()
    {
        $attributes = Attribute::find()->All();
        if(empty($attributes)) return;
        $data = ArrayHelper::toArray($attributes, [
            Attribute::class => ['slug',],
        ]);
        return ArrayHelper::getColumn($data, "slug");

    }
}
