<?php

namespace bitcream\pim\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\pim\custom\common\behaviors\StatusBehaviors;
use bitcream\pim\custom\common\behaviors\CreateUpdateBehaviors;
/**
 * This is the model class for table "{{%attribute_translation}}".
 *
 */
class AttributeTranslation extends base\AttributeTranslation
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }
}
