<?php
namespace bitcream\pim\custom\common\widget;

use yii\helpers\Html;
use yii\widgets\InputWidget;
use Yii;
use yii\helpers\ArrayHelper;

class ProductFieldWidget extends InputWidget
{
    private $configuration;
    private $attributeObject;
    public $options;
    public function init()
    {
        parent::init();
        $this->setDefaultConfiguration();
    }

    public function run()
    {
        $attribute = $this->model->getDynamicAttribute($this->attribute);
        $this->attributeObject = $attribute;
        switch ($attribute->type) {
            case 'si-no':
                return \Emberware\Evidia\Toolkit\Field\SwitchInput::Widget($this->configuration);
                break;
            case 'date':
                return \Emberware\Evidia\Toolkit\Field\Date::Widget($this->configuration);
                break;
            case 'selezione-singola':
            case 'selezione-singola-modello':
                return \kartik\select2\Select2::widget($this->selectConfiguration($this->attribute, false));
                break;
            case 'selezione-multipla':
            case 'selezione-multipla-modello':
                return \kartik\select2\Select2::widget($this->selectConfiguration($this->attribute, true));
                break;
            case 'immagine':
            case 'file':
                return \floor12\files\components\FileInputWidget::widget($this->configuration);
                break;
            case 'numero':
                return \kartik\number\NumberControl::widget($this->selectNumberConfiguration($this->attribute, $attribute->description));
                break;
            case 'galleria-immagini':
                return \floor12\files\components\FileInputWidget::widget($this->fileConfiguration($this->attribute));
                break;
            case 'testo':
            default:
                return Html::activeTextInput($this->model, $this->attribute, ['class' => 'form-control']);
                break;
        }
    }

    private function setDefaultConfiguration(){
        $this->configuration = [
            'model' => $this->model,
            'attribute' => $this->attribute,        
        ];
    }

    private function selectConfiguration(string $attribute, bool $multiple = false){
        return ArrayHelper::merge($this->configuration, [
            'name' => $attribute,
            'data' => $this->attributeData(),
            'value' => $this->model->$attribute,
            'options' => [
                'placeholder' => 'Select a '.$attribute.' ...',
                'multiple' => $multiple,
            ],
        ]);
    }

    private function fileConfiguration(string $attribute, bool $multiple = false){
        return $this->configuration;
    }

    public function attributeData(){
        if($this->attributeObject->isSelectValue()) { //dati attribute value
            return ArrayHelper::map($this->attributeObject->attributeValues, 'id', 'title'); 
        }
        if($this->attributeObject->isModelValue()
            && !empty($this->attributeObject->productModels)) { //dati model value
            return ArrayHelper::map($this->attributeObject->productModels[0]->products, 'id', 'title');
        }
        return [];
    }

    private function selectNumberConfiguration(string $attribute, $prefix = NULL){
        $dispOptions = ['class' => 'form-control kv-monospace']; 
        $saveCont = ['class' => 'kv-saved-cont'];
        return ArrayHelper::merge($this->configuration, [
            'name' => $attribute,
            'value' => $this->attributeData(),
            'maskedInputOptions' => [
                'prefix' => str_replace(array("\n","\r"), "", strip_tags($prefix))." ",
                'groupSeparator' => '.',
                'radixPoint' => ',',
            ],
            'displayOptions' => $dispOptions,
            'saveInputContainer' => $saveCont
        ]);
    }
}