<?php

namespace bitcream\pim\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product_definition}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product_model}}`
 */
class M220103141844AddProductModelIdIdColumnToProductDefinitionTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product_definition}}', 'product_model_id', $this->integer()->null());

        // creates index for column `product_model_id`
        $this->createIndex(
            '{{%idx-product_definition-product_model_id}}',
            '{{%product_definition}}',
            'product_model_id'
        );

        // add foreign key for table `{{%product_model}}`
        $this->addForeignKey(
            '{{%fk-product_definition-product_model_id}}',
            '{{%product_definition}}',
            'product_model_id',
            '{{%product_model}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product_model}}`
        $this->dropForeignKey(
            '{{%fk-product_definition-product_model_id}}',
            '{{%product_definition}}'
        );

        // drops index for column `product_model_id`
        $this->dropIndex(
            '{{%idx-product_definition-product_model_id}}',
            '{{%product_definition}}'
        );

        $this->dropColumn('{{%product_definition}}', 'product_model_id');
    }
}
