<?php

namespace bitcream\pim\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product_model}}`
 */
class M220114120052AddProductModelIdColumnToProductTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product}}', 'product_model_id', $this->integer()->null());

        // creates index for column `product_model_id`
        $this->createIndex(
            '{{%idx-product-product_model_id}}',
            '{{%product}}',
            'product_model_id'
        );

        // add foreign key for table `{{%product_model}}`
        $this->addForeignKey(
            '{{%fk-product-product_model_id}}',
            '{{%product}}',
            'product_model_id',
            '{{%product_model}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product_model}}`
        $this->dropForeignKey(
            '{{%fk-product-product_model_id}}',
            '{{%product}}'
        );

        // drops index for column `product_model_id`
        $this->dropIndex(
            '{{%idx-product-product_model_id}}',
            '{{%product}}'
        );

        $this->dropColumn('{{%product}}', 'product_model_id');
    }
}
