<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
/* @var $this yii\web\View */
/* @var $model bitcream\pim\custom\common\models\ProductModelValue */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="product-model-value-form">

    <?php $form = ActiveForm::begin(); ?>
        <div class="row">
            <div class="col-md-6 col-xs-12">
                <?= $form->field($model, 'attribute_id')->widget(Select2::classname(), [
                    'name' => 'attribute_id',
                    'class' => 'form-group attribute_ids form-control',
                    'value' => ArrayHelper::map($attributes, 'id', function ($attribute) {
                        return $attribute['title'];
                    }),
                    'id' => 'attribute_id',
                    'data' => ArrayHelper::map($attributes, 'id', function ($attribute) {
                        return $attribute['title'];
                    }),
                    'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select attribute')]
                ])->label(Yii::t('app', 'Attribute'));?>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 col-xs-12">
                <?= $form->field($model, 'product_model_id')->widget(Select2::classname(), [
                    'name' => 'product_model_id',
                    'class' => 'form-group product_model_ids form-control',
                    'value' => ArrayHelper::map($productModels, 'id', function ($productModel) {
                        return $productModel['name'];
                    }),
                    'id' => 'product_model_id',
                    'data' => ArrayHelper::map($productModels, 'id', function ($productModel) {
                        return $productModel['name'];
                    }),
                    'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select product model')]
                ])->label(Yii::t('app', 'Product model'));?>
            </div>
        </div>

        <div class="form-group">
            <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
        </div>

    <?php ActiveForm::end(); ?>

</div>
