<?php

use yii\helpers\Html;
use Emberware\Evidia\Model\Datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'consultant-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'Value'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->value, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                ['attribute'=>Yii::t('app', 'Product'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return (isset($data->product)? $data->product->title: "");}
                ],
                ['attribute'=>Yii::t('app', 'Attribute'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return (isset($data->attributeObject)? $data->attributeObject->title: "");}
                ],
                'language',
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "paging" => false,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>