<?php

namespace bitcream\pim\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%attribute_translation}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%attribute}}`
 */
class M220103141512AddAttributeIdColumnToAttributeTranslationTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%attribute_translation}}', 'attribute_id', $this->integer()->null());

        // creates index for column `attribute_id`
        $this->createIndex(
            '{{%idx-attribute_translation-attribute_id}}',
            '{{%attribute_translation}}',
            'attribute_id'
        );

        // add foreign key for table `{{%attribute}}`
        $this->addForeignKey(
            '{{%fk-attribute_translation-attribute_id}}',
            '{{%attribute_translation}}',
            'attribute_id',
            '{{%attribute}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%attribute}}`
        $this->dropForeignKey(
            '{{%fk-attribute_translation-attribute_id}}',
            '{{%attribute_translation}}'
        );

        // drops index for column `attribute_id`
        $this->dropIndex(
            '{{%idx-attribute_translation-attribute_id}}',
            '{{%attribute_translation}}'
        );

        $this->dropColumn('{{%attribute_translation}}', 'attribute_id');
    }
}
