<?php

namespace bitcream\pim\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product_definition}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%attribute}}`
 */
class M220103141740AddAttributeIdColumnToProductDefinitionTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product_definition}}', 'attribute_id', $this->integer()->null());

        // creates index for column `attribute_id`
        $this->createIndex(
            '{{%idx-product_definition-attribute_id}}',
            '{{%product_definition}}',
            'attribute_id'
        );

        // add foreign key for table `{{%attribute}}`
        $this->addForeignKey(
            '{{%fk-product_definition-attribute_id}}',
            '{{%product_definition}}',
            'attribute_id',
            '{{%attribute}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%attribute}}`
        $this->dropForeignKey(
            '{{%fk-product_definition-attribute_id}}',
            '{{%product_definition}}'
        );

        // drops index for column `attribute_id`
        $this->dropIndex(
            '{{%idx-product_definition-attribute_id}}',
            '{{%product_definition}}'
        );

        $this->dropColumn('{{%product_definition}}', 'attribute_id');
    }
}
