<?php

namespace bitcream\pim\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product_model_value}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%attribute}}`
 */
class M220614123502AddAttributeIdColumnToAtProductModelValueTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product_model_value}}', 'attribute_id', $this->integer()->null());

        // creates index for column `attribute_id`
        $this->createIndex(
            '{{%idx-at_product_model_value-attribute_id}}',
            '{{%product_model_value}}',
            'attribute_id'
        );

        // add foreign key for table `{{%attribute}}`
        $this->addForeignKey(
            '{{%fk-product_model_value-attribute_id}}',
            '{{%product_model_value}}',
            'attribute_id',
            '{{%attribute}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%attribute}}`
        $this->dropForeignKey(
            '{{%fk-product_model_value-attribute_id}}',
            '{{%product_model_value}}'
        );

        // drops index for column `attribute_id`
        $this->dropIndex(
            '{{%idx-product_model_value-attribute_id}}',
            '{{%product_model_value}}'
        );

        $this->dropColumn('{{%product_model_value}}', 'attribute_id');
    }
}
