<?php

namespace bitcream\pim\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%at_product_model_value}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product_model}}`
 */
class M220614123554AddAttributeIdColumnToAtProductModelValueTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product_model_value}}', 'product_model_id', $this->integer()->null());

        // creates index for column `product_model_id`
        $this->createIndex(
            '{{%idx-product_model_value-product_model_id}}',
            '{{%product_model_value}}',
            'product_model_id'
        );

        // add foreign key for table `{{%product_model}}`
        $this->addForeignKey(
            '{{%fk-product_model_value-product_model_id}}',
            '{{%product_model_value}}',
            'product_model_id',
            '{{%product_model}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product_model}}`
        $this->dropForeignKey(
            '{{%fk-product_model_value-product_model_id}}',
            '{{%product_model_value}}'
        );

        // drops index for column `product_model_id`
        $this->dropIndex(
            '{{%idx-product_model_value-product_model_id}}',
            '{{%product_model_value}}'
        );

        $this->dropColumn('{{%product_model_value}}', 'product_model_id');
    }
}
