<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use Emberware\Evidia\Toolkit\Field\SwitchInput;
use Emberware\Evidia\Toolkit\Field\WYSIWYG;
//use Emberware\Evidia\Toolkit\Field\Select2;
use kartik\select2\Select2;
/* @var $this yii\web\View */
/* @var $model bitcream\pim\custom\common\models\Attribute */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="attribute-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'description')->widget(WYSIWYG::className()) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <label class="control-label">Type</label>
            <?= Select2::widget([
                'name' => 'type',
                'data' => [
                    "testo" => "Testo", 
                    "area-testo" => "Area di testo", 
                    "si-no" => "Si/No", 
                    "numero" => "Numero",
                    "date" => "Data",
                    "selezione-singola" => "Selezione singola",                   
                    "selezione-multipla" => "Selezione multipla",   
                    "selezione-singola-modello" => "Selezione singola modello",                 
                    "selezione-multipla-modello" => "Selezione multipla modello",                    
                    "immagine" => "Immagine",                    
                    "galleria-immagini" => "Galleria di immagini",
                    "file" => "File",
                    "gerarchia-genitore" => "Gerarchia genitore", 
                    "gerarchia-figlio" => "Gerarchia figlio", 
                ],
                'value' => $model->type,
                'options' => [
                    'placeholder' => 'Select a type ...'
                ],
            ]);?><br>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?=$form->field($model, 'translatable')->widget(SwitchInput::classname()) ?>
        </div>
    </div>
    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
