<?php

namespace bitcream\pim\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product_value}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M220103141630AddProductIdColumnToProductValueTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product_value}}', 'product_id', $this->integer()->null());

        // creates index for column `product_id`
        $this->createIndex(
            '{{%idx-product_value-product_id}}',
            '{{%product_value}}',
            'product_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-product_value-product_id}}',
            '{{%product_value}}',
            'product_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-product_value-product_id}}',
            '{{%product_value}}'
        );

        // drops index for column `product_id`
        $this->dropIndex(
            '{{%idx-product_value-product_id}}',
            '{{%product_value}}'
        );

        $this->dropColumn('{{%product_value}}', 'product_id');
    }
}
