<?php

namespace bitcream\smartsignage\custom\backend\controllers;

use bitcream\smartsignage\custom\backend\models\LayoutZone;
use Yii;
use bitcream\smartsignage\custom\backend\models\PresetContent;
use bitcream\smartsignage\custom\backend\models\PresetContentSearch;
use bitcream\smartsignage\custom\backend\models\Preset;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * PresetContentController implements the CRUD actions for PresetContent model.
 */
class PresetContentController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all PresetContent models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new PresetContentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single PresetContent model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new PresetContent model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new PresetContent();
        $presets = Preset::find()->all();
        $zone = LayoutZone::find()->all();
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
            'presets' => $presets,
            'zone' => $zone,
            'objects' => [],
        ]);
    }

    /**
     * Updates an existing PresetContent model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $presets = Preset::find()->all();
        $zones = LayoutZone::find()->all();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        $objects = (!empty($model->class) ? $model->class::find()->all() : []);

        return $this->render('update', [
            'model' => $model,
            'presets' => $presets,
            'zone' => $zones,
            'objects' => $objects,
        ]);
    }

    /**
     * Deletes an existing PresetContent model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the PresetContent model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return PresetContent the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = PresetContent::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('smartsignage', 'The requested page does not exist.'));
    }
}
