<?php

use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'layout-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('smartsignage', 'Zone name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->zone_name, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                'coord_x',
                'coord_y',
                'size_width',
                'size_height',
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('smartsignage', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('smartsignage',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>